// Hero Section - Parallax
document.addEventListener("mousemove", parallax);

function parallax(e) {
    this.querySelectorAll('.layer').forEach(layer => {
        const speed = layer.getAttribute('data-speed');
        const x = (window.innerWidth - e.pageX * speed) / 100;
        const y = (window.innerWidth - e.pageY * speed) / 100;
        // console.log('x value ' + x, "y value " + y); // For Testing
        layer.style.transform = "translate(" + x + "px , " + y + "px)";
    });
}

// After DOM Load
document.addEventListener('DOMContentLoaded', function() {
    // Slider JS
    let listOfSliders = document.querySelectorAll('.dsm-slider'); // .dsm-slider
    listOfSliders.forEach(function(value, index, obj) {
        let inputs = value.querySelectorAll('input');
        let uiElement = value.querySelector('.dsm-dual-slider'); // .dsm-dual-slider        
        inputs.forEach(function(value, index, obj) {
            value.addEventListener("input", function(e) {
                if (e.target.classList.contains('dsm-slider-handle-top')) {
                    // handle-top                 
                    uiElement.style.top = `${e.target.value}%`;
                } else {
                    // handle bottom
                    uiElement.style.bottom = `${100-e.target.value}%`;
                }
            });
        });
    });
    
  
}, false);
